package jamezo97.clonecraft.entity.clone.AI;

import jamezo97.clonecraft.entity.clone.EntityClone;
import jamezo97.clonecraft.entity.clone.PlayerTeam;

import java.util.List;
import java.util.Random;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;

public class EntityAIAttackEnemies extends EntityAIBase {

	EntityClone clone = null;
	
	Random rand = new Random();
	
	public EntityAIAttackEnemies(EntityClone entityMyPerson) {
		clone = entityMyPerson;
	}

	public boolean shouldExecute() {
		if(clone != null && clone.options != null && !clone.isEatingFood()){
			return clone.options.fight.value();
		}
		return false;
	}

	int noImprovement = 0;
	
	int update = 0;
	
	float lastHealth = 0;
	
	
	
	@Override
	public boolean continueExecuting() {
		if(clone.getEntityToAttack() != null){
			lastHealth = clone.getEntityToAttack().getHealth();
		}
		if(clone.getEntityToAttack() == null){
			EntityLivingBase newEntity = getClosestEntityToAttackExcluding(null);
			if(newEntity != null){
				clone.setTarget(newEntity);
				clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
			}
		}else if(clone.getEntityToAttack().isEntityAlive()){
			if(rand.nextInt(10) == 0){
				EntityLivingBase newEntity = getClosestEntityToAttackExcluding(null);
				if(newEntity != null && newEntity != clone.getEntityToAttack()){
					double d1 = clone.getDistanceSqToEntity(clone.getEntityToAttack());
					double d2 = clone.getDistanceSqToEntity(newEntity);
					if(d2 < d1){
						clone.setTarget(newEntity);
						clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
					}
				}
			}else if(update++ > 1){
				update = 0;
				clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
			}
			if((clone.options.shouldAttack(clone.getEntityToAttack())?false:!clone.revenge) && !(clone.team == PlayerTeam.Traitor && clone.getEntityToAttack() instanceof EntityPlayer)){
				clone.setTarget(null);
				clone.setPathToEntity(null);
			}else{
				if(clone.getNavigator().noPath()){
					clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
				}
				clone.attackEntity(clone.getEntityToAttack(), clone.getDistanceToEntityFromHead(clone.getEntityToAttack()));
			}
			if(clone.prevPosX == clone.posX && clone.prevPosY == clone.posY && clone.prevPosZ == clone.posZ && clone.getEntityToAttack().getHealth() == lastHealth){
				noImprovement++;
				if(noImprovement > 30){
					EntityLivingBase newEntity = getClosestEntityToAttackExcluding(clone.getEntityToAttack());
					if(newEntity != null){
						clone.setTarget(newEntity);
						clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
					}
				}
			}else{
				noImprovement = 0;
			}
		}else{
			clone.setTarget(null);
			clone.setPathToEntity(null);
			if(clone.attackDelay > 3){
				clone.attackDelay = 3;
			}
		} 
		return super.continueExecuting();
	}
	
	public EntityLivingBase getClosestEntityToAttackExcluding(EntityLivingBase entity){
		List list = clone.worldObj.getEntitiesWithinAABBExcludingEntity(clone, clone.boundingBox.expand(32D, 16D, 32D));
		if(entity != null){
			list.remove(entity);
		}
		
		double distance = -1;
		EntityLivingBase toAttack = null;
		for(int a = 0; a < list.size(); a++){
			Object o = list.get(a);
			if(o != null && o instanceof EntityLivingBase){
				EntityLivingBase e = (EntityLivingBase)o;
				if(e.isEntityAlive() && clone.canEntityBeSeen(e)){
					if(clone.options.shouldAttack(e)){
						double distancesqr = distanceSquared(clone, e);
						if(distancesqr < distance || distance == -1){
							distance = distancesqr;
							toAttack = e;
						}
					}
				}
				if(e instanceof EntityPlayer && clone.team == PlayerTeam.Traitor){
					double distancesqr = distanceSquared(clone, e);
					if(distancesqr < distance || distance == -1){
						distance = distancesqr;
						toAttack = e;
					}
				}
			}
		}
		return toAttack;
	}
	
	public double distanceSquared(Entity e1, Entity e2){
		double d1 = e1.posX - e2.posX;
		double d2 = e1.posY - e2.posY;
		double d3 = e1.posZ - e2.posZ;
		return d1*d1 + d2*d2 + d3*d3;
		
	}
	
	

}
